import fs from 'fs';
import { CFG } from './config.js';

const defState = {
  symbol: CFG.SYMBOL,
  equityUSDT: 3800,
  pos: null,
  cooldownUntilBar: -1,
  logs: []
};

export function loadState() {
  if (!fs.existsSync(CFG.STATE_FILE)) {
    fs.writeFileSync(CFG.STATE_FILE, JSON.stringify(defState, null, 2));
    return JSON.parse(JSON.stringify(defState));
  }
  return JSON.parse(fs.readFileSync(CFG.STATE_FILE, 'utf8'));
}

export function saveState(s) {
  fs.writeFileSync(CFG.STATE_FILE, JSON.stringify(s, null, 2));
}
