import dotenv from 'dotenv';
dotenv.config();

const num = (k, d=null) => process.env[k] !== undefined ? Number(process.env[k]) : d;

export const CFG = {
  PORT: num('PORT', 8080),
  TOKEN: process.env.WEBHOOK_TOKEN,
  PAPER: (process.env.PAPER || 'true').toLowerCase() === 'true',
  BINANCE: {
    KEY: process.env.BINANCE_API_KEY || '',
    SECRET: process.env.BINANCE_API_SECRET || '',
    BASE_URL: process.env.BINANCE_BASE_URL || 'https://api.binance.us'
  },
  SYMBOL: process.env.SYMBOL || 'BTCUSDT',
  QPREC: num('QUOTE_PRECISION', 2),
  MIN_NOTIONAL: num('MIN_NOTIONAL', 30),
  FEE: num('FEE_RATE', 0.001),
  ATR_BANDS: {
    HI3: num('ATR_BAND_HI3', 0.03),
    HI2: num('ATR_BAND_HI2', 0.02),
    MID: num('ATR_BAND_MID', 0.01)
  },
  SL_K: num('SL_K', 1.5),
  FLIP_R: num('FLIP_R', 2.0),
  NEAR_FLIP_GAP: num('NEAR_FLIP_GAP', 0.2),
  COOLDOWN_BARS: num('COOLDOWN_BARS', 2),
  TRAIL: {
    MIN: num('TRAIL_MIN', 0.005),
    MAX: num('TRAIL_MAX', 0.016),
    ATR_FACTOR: num('TRAIL_ATR_FACTOR', 0.5),
    ADX_STRONG: num('TRAIL_ADX_STRONG', 30),
    ADX_WEAK: num('TRAIL_ADX_WEAK', 20)
  },
  STATE_FILE: process.env.STATE_FILE || './bot-state.json'
};
