# Frozen-R_base BTCUSDT Bot (Node.js)

This bot implements the **frozen R_base pyramiding strategy** for BTCUSDT on **Binance.US** using **TradingView webhooks**. It supports **paper mode** (default) and **live mode**. One protective order is maintained at all times (hard stop pre-flip, trailing after flip) via `cancelReplace`.

## Quick start (VPS or cPanel Node App)
1. Upload the ZIP and unzip it into your app root (e.g., `/home/<user>/bot.powerfulpurse.com/`).
2. SSH into the directory or use cPanel's Terminal, then:
   ```bash
   npm i
   cp .env.example .env
   # Edit .env: set WEBHOOK_TOKEN, keep PAPER=true for test
   npm run start
   ```
3. In TradingView, create an alert that POSTs to:
   ```
   http://bot.powerfulpurse.com/webhook
   ```
   with header:
   ```
   X-Auth-Token: <WEBHOOK_TOKEN from .env>
   ```
   Use the **ENTRY** payload below. Optionally add a frequent **TICK** alert.

### cPanel Application Manager (if available)
- Create a **Node.js Application**, set **Application URL** to your subdomain `bot.powerfulpurse.com`.
- Set **Application startup file** to `src/server.js`.
- Add environment variable `WEBHOOK_TOKEN` or keep `.env`.
- Click **Create**, then **Run NPM Install**, and **Restart** the app.
- The app will be served by Apache at your subdomain; no port in the URL required.
- If your host requires Passenger-provided PORT, ensure `process.env.PORT` is honored (the code already does this).

## Webhook schemas

### ENTRY alert (from your 4H strategy)
```
{
  "type": "ENTRY",
  "symbol": "BTCUSDT",
  "ts": "{{timenow}}",
  "price": {{close}},
  "atr": {{atr(14)}},
  "atrPct": {{atr(14) / close}},
  "ema20": {{ta.ema(close,20)}},
  "sma50": {{ta.sma(close,50)}},
  "sma200": {{ta.sma(close,200)}},
  "adx14": {{ta.adx(14)}},
  "diplus": {{ta.diplus(14)}},
  "diminus": {{ta.diminus(14)}},
  "swingHigh10": {{ta.highest(high,10)[1]}},
  "barIndex": {{bar_index}},
  "timeframe": "4H"
}
```

### TICK alert (optional; allows more granular adds & trailing)
> If you run the TICK on 4H, keep it `once per bar`.> If you run it on a lower timeframe, indicators will differ; it's acceptable for live running, but test first.

```
{
  "type": "TICK",
  "symbol": "BTCUSDT",
  "ts": "{{timenow}}",
  "price": {{close}},
  "high": {{high}},
  "low": {{low}},
  "atrPct": {{ta.atr(14) / close}},
  "adx14": {{ta.adx(14)}},
  "diplus": {{ta.diplus(14)}},
  "diminus": {{ta.diminus(14)}},
  "swingHigh10": {{ta.highest(high,10)[1]}},
  "ema20": {{ta.ema(close,20)}}
}
```

## Strategy recap (frozen R_base)
- **Sizing** (ATR% bands): >3%→20%, 2–3%→40%, 1–2%→80%, ≤1%→100%.
- **Stop**: entry − 1.5 × ATR(14).
- **R_base**: distance from entry to initial stop; frozen for all triggers.
- **Adds (pre-trail)**: based on starting fraction (20→40→80→100), gated by ADX/DI+ breakout filters and house-money risk cap. Skip if within 0.2R of +2R flip.
- **Flip to trailing**: at +2.0 × R_base.
- **Trailing**: trailPct = clamp(0.5%..1.6%, 0.5×ATR%×g(ADX)), tighten 25% ≥ +2R.

## Pine v5 snippets

**ENTRY (use on 4H; alert once per bar close)**
```pine
//@version=5
indicator("Bot ENTRY Alert", overlay=true)
ema20 = ta.ema(close,20)
sma50 = ta.sma(close,50)
sma200 = ta.sma(close,200)
adx14 = ta.adx(14)
diplus = ta.diplus(14)
diminus = ta.diminus(14)
atr14 = ta.atr(14)
atrPct = atr14/close
swingHigh10 = ta.highest(high,10)[1]
slope50 = ta.sma(close,50) - ta.sma(close,50)[6]

entryCond = close>ema20 and close[1]<=ema20[1] and close>sma200 and slope50>0

if entryCond
    alert_message = str.format('{{"type":"ENTRY","symbol":"BTCUSDT","ts":"{0}","price":{1},"atr":{2},"atrPct":{3},"ema20":{4},"sma50":{5},"sma200":{6},"adx14":{7},"diplus":{8},"diminus":{9},"swingHigh10":{10},"barIndex":{11},"timeframe":"4H"}}',
        timenow, close, atr14, atrPct, ema20, sma50, sma200, adx14, diplus, diminus, swingHigh10, bar_index)
    alert(alert_message, alert.freq_once_per_bar_close)
```

**TICK (optional; can be same timeframe)**  
```pine
//@version=5
indicator("Bot TICK Alert", overlay=false)
alert_message = str.format('{{"type":"TICK","symbol":"BTCUSDT","ts":"{0}","price":{1},"high":{2},"low":{3},"atrPct":{4},"adx14":{5},"diplus":{6},"diminus":{7},"swingHigh10":{8},"ema20":{9}}}',
    timenow, close, high, low, ta.atr(14)/close, ta.adx(14), ta.diplus(14), ta.diminus(14), ta.highest(high,10)[1], ta.ema(close,20))
alert(alert_message, alert.freq_once_per_bar_close)
```
